import 'react-native-gesture-handler';
import * as React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createDrawerNavigator } from '@react-navigation/drawer';
const Drawer = createDrawerNavigator();

import FirstPage from './FirstPage';
import SecondPage from './SecondPage';
import ThirdPage from './ThirdPage';
import FourthPage from './FourthPage';


function App() {
  return (
    <NavigationContainer>
      <Drawer.Navigator initialRouteName="FirstPage">
        <Drawer.Screen
          name="FirstPage"
          component={FirstPage}
        />
        <Drawer.Screen
          name="SecondPage"
          component={SecondPage}
        />
        <Drawer.Screen
          name="ThirdPage"
          component={ThirdPage}
        />
        <Drawer.Screen
          name="FourthPage"
          component={FourthPage}
        />
      </Drawer.Navigator>
    </NavigationContainer>
  );
}

export default App;
